#rem 
 Garage Door Control.bas.
  
 Hardware:
 This PICAXE circuit is a replacemant for the Jan 1994 4000-series CMOS circuit whose wire-wrap
 had become unreliable. The box thumbwheel switches, diodes and the manual push-button are retained
 A new keypad in 2016 keypad has 12 buttons with 12 wires, plus common (ground).
 This keypad is lit, controlled by another wire. It uses 9-14 Vdc or VAC at 800 MA via a coax plug
 The ENTR and CLR buttons are located like telco * and # and go to the processor separately.
 All number buttons are diode-orred as "AnyPort" and also comnnected to the 6 thumbwheels in pairs.
 The thumbwheels are BCD which can accomodate 8 numbers each. The other 2 are rotated..
 This selects three 'DigiPort' lines which are the operate code. 
 All 6 input lines have pullups, and go to zero when pressed..
 
 The requirements are:.
 1. Door triggering requires the correct code to be pressed in a sequience of 3 presses from idle..
 2. If any press is wrong, number presses are ignored for "LockoutTime".
 3. If no button is pressed for "IdleTime" then goes to idle.
 4. If CLR is pressed then goes to idle immediately.
 5. Any number pressed after door operates before 'OperateTime' elapses will re-trigger.the door.
 
 The implementation is by a State Machine on PressCount. The permitted transition and actions are:
 1. 0 is idle. All changes greater than 0 are done during interrupt, and are increases.
 2. The CLRPort interrupt is enabled every main loop.
 3. The anyport interrupt is enabled every main loop except for state 3.
 4. The ENTRort interrupt is enabled every main loop.
 5. The main loop delay depends on the state as follows:
 	0,1,2: 	IdleTime
 	3:     	LockupTime
 	4 and up:   OperateTime
 6. After any main loop delay without an interrupt, the state goes to 0.
 7. All other state changes are made in the interrupt routine as follows:
 	If it is an CLRPort interrupt:
 	Always goes to state 0.
 	
 	If it is an AnyPort interrupt:
 	0 > 1, 1 > 2, and 2 > 4 are on correct digiENTRPort press after release.
 	0 > 3, 1 > 3, and 2 > 3 are on incorrect digiENTRPort press after release
 	4 and up increments on any anyport press.
 8. The door is triggered immediately in the AnyPort interrupt routine for states 4 and up 
 9. Any key press turns the lamps on, they go out after a number of idle cycles.
 
 John Saunders 12/12/2016 Added key lighting control for new Navy keypad
#endrem

#PICAXE 14M2

'Input Ports, low active
symbol AnyPort     = PINC.0	'Diode OR of keys numbers 0 - 9.
symbol CLRPort     = PINC.1	'Resets the number pressed and cancels tineout
symbol ENTRPort    = PINC.2 	'Generates timeout
symbol Digit1Port  = PINB.5	'The number button selected by the left 2 thumbwheels
symbol Digit2Port  = PINC.3	'The number button selected by the middle 2 thumbwheels
symbol Digit3Port  = PINC.4	'The number button selected by the right 2 thumbwheels

'Output Port
symbol GatePort    = B.1 	'Drives the MOSFET to operate the garage door
symbol ShutoffPort = B.4	'Whem high turns off the key lamps


'Variables

symbol PressCount    = B1	'This is the state variable
symbol OldPressCount = B2
symbol SHTimeout     = B3	'Counts down from SHdelay each loop

'Constants in ms
symbol IdleTime		= 5000	'Maximum time to press the next button
symbol LatchTime  	= 500		'Output pulse length
symbol LockupTime 	= 15000	'After a wrong kewy press
symbol OperateTime 	= 8000	'During this time the door movement may be halted
symbol BounceTime		= 100
symbol SHdelay          = 5	'The number of main loops before extinguishing the lamps

Init:
SETFREQ m4
LET DIRSB = %00010010			
LET DIRSC = %00000000
LOW GatePort
LET PressCount = 0
LET OldPressCount = 0
HIGH ShutoffPort


main:
IF PressCount = 3 THEN
	SETINT OR %00000000, %00000110		'CLRPort and ENTRPort only
ELSE
	SETINT  OR %00000000, %00000111	'Either CLRPort or ENTRPort or AnyPort
ENDIF
SELECT PressCount
	CASE 0,1,2
		PAUSE IdleTime
	CASE 3
		PAUSE LockupTime
	ELSE
		PAUSE OperateTime
ENDSELECT
SETINT OFF
IF OldPressCount = PressCount THEN		'Reset state for no activity
	LET PressCount = 0
ELSE
	LET OldPressCount = PressCount
ENDIF
IF SHTimeout > 0 THEN			
	DEC SHTimeout
	LOW ShutoffPort
ELSE							'End of illumination
	HIGH ShutoffPort
ENDIF
GOTO main

interrupt:
IF CLRPort = 0 THEN				'Stop door if moving and reset
	DO 
		PAUSE 20
	LOOP WHILE CLRPort = 0
	IF Presscount > 3 THEN
		HIGH GatePort
		PAUSE LatchTime
		LOW GatePort
	ENDIF
	LET PressCount = 0
ELSEIF ENTRPort = 0 THEN
	DO 
		PAUSE 20
	LOOP WHILE ENTRPort = 0
	LET PressCount = 3			'Initiate lockout anytime
ELSE
	SELECT PressCount
		CASE 3 	'Should not happen since AnyPort interrupt is not enabled
			LET PressCount = 3
		CASE 2
			IF Digit3Port = 0 THEN
				LET PressCount = 4
			ELSE
				LET PressCount = 3
			ENDIF 
		CASE 1
			IF Digit2Port = 0 THEN
				LET PressCount = 2
			ELSE
				LET PressCount = 3
			ENDIF 
		CASE 0
			IF Digit1Port = 0 THEN
				LET PressCount = 1
			ELSE
				LET PressCount = 3
			ENDIF
		ELSE
			LET PressCount = PressCount +1 'Avoids going back to 0 if more presses
	ENDSELECT
	IF Presscount > 3 AND Digit3Port = 0 THEN	'Operate the door
		HIGH GatePort
		PAUSE LatchTime
		LOW GatePort
	ENDIF
	DO 
		PAUSE 20
	LOOP WHILE AnyPort = 0
ENDIF
PAUSE BounceTime
LET SHTimeout = SHdelay
RETURN
